# Details

## Workflows Array

You can put many workflows to the array defined in `workflowmanagement.php`.
Look at the base structure for the workflows configuration.

```php
<?php

return [
    1 => [
        // workflow for products objects
    ],
    2 => [
        // a general workflow for documents, objects and assets
    ]
];
```

## Available options

| Configuration Key                                                             | Type        | Is required?   | Description                                                                                                                                                                                                                                                                                                                                                                                           |
|-------------------------------------------------------------------------------|-------------|----------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `[id]["name"]`                                                                | string      | Y              | The display name, is shown at the workflow window in the administration panel.                                                                                                                                                                                                                                                                                                                        |
| `[id]["id"]`                                                                  | int         | Y              | Unique ID chosen by you.                                                                                                                                                                                                                                                                                                                                                                              |
| `[id]["workflowSubject"]`                                                     | array       | Y              | Defined for which elements the workflow is for                                                                                                                                                                                                                                                                                                                                                        |
| `[id]["workflowSubject"]["types"]`                                            | array       | Y              | Array with allowed types of elements using the workflow (asset,object,document).                                                                                                                                                                                                                                                                                                                      |
| `[id]["workflowSubject"]["classes"]`                                          | array       | Objects only   | The class id's that this workflow applies to, defaults to NONE                                                                                                                                                                                                                                                                                                                                        |
| `[id]["workflowSubject"]["objectTypes"]`                                      | array       | Objects only   | The type of objects to support (i.e. object or variant)                                                                                                                                                                                                                                                                                                                                               |
| `[id]["workflowSubject"]["assetTypes"]`                                       | array       | Assets only    | Asset types the workflow is for, defaults to NONE. For example: image, video                                                                                                                                                                                                                                                                                                                          |
| `[id]["workflowSubject"]["documentTypes"]`                                    | array       | Documents only | Document types the workflow is for, defaults to NONE. For example: page, snippet                                                                                                                                                                                                                                                                                                                      |
| `[id]["enabled"]`                                                             | boolean     | Y              | Flag to enable / disable the workflow.                                                                                                                                                                                                                                                                                                                                                                |
| `[id]["defaultState"]`                                                        | string      | Y              | The default state for elements. The state has to be chosen from the `["workflows"][i]["states"]` array.                                                                                                                                                                                                                                                                                               |
| `[id]["defaultStatus"]`                                                       | string      | Y              | The default status for elements. The status has to be chosen from the `["workflows"][i]["statuses"]` array.                                                                                                                                                                                                                                                                                           |
| `[id]["allowUnpublished"]`                                                    | boolean     | Y              | Set true to allow the workflow on unpublished elements, false to only allow published elements.                                                                                                                                                                                                                                                                                                       |
| `[id]["states"]`                                                              | array       | Y              | Array of available states in the workflow.                                                                                                                                                                                                                                                                                                                                                            |
| `[id]["states"][j]["name"]`                                                   | string      | Y              | The name of the state (used as a key for example in the code).                                                                                                                                                                                                                                                                                                                                        |
| `[id]["states"][j]["label"]`                                                  | string      | Y              | The label of the state - used in the administration panel to show the state of elements.                                                                                                                                                                                                                                                                                                              |
| `[id]["states"][j]["color"]`                                                  | string      | N              | UI colour / theme. You can choose the color visible with the label.                                                                                                                                                                                                                                                                                                                                   |
| `[id]["statuses"]`                                                            | array       | Y              | Array of available statuses in the workflow.                                                                                                                                                                                                                                                                                                                                                          |
| `[id]["statuses"][j]["name"]`                                                 | string      | Y              | The name of the status (used as a key for example in the code).                                                                                                                                                                                                                                                                                                                                       |
| `[id]["statuses"][j]["label"]`                                                | string      | Y              | The label of the status - used in the administration panel to show the status of elements.                                                                                                                                                                                                                                                                                                            |
| `[id]["statuses"][j]["objectLayout"]`                                         | int         | N              | **It works only with objects.** It's an id of the default custom layout loaded with that workflow status.                                                                                                                                                                                                                                                                                             |
| `[id]["statuses"][j]["elementPublished"]`                                     | boolean     | N              | **It works only with objects and page snippets.** The element gets published entering in this status if all mandatory fields are filled.                                                                                                                                                                                                                                                              |
| `[id]["actions"]`                                                             | array       | Y              | Actions definitions, operations which could be amplify to elements.                                                                                                                                                                                                                                                                                                                                   |
| `[id]["actions"][j]["name"]`                                                  | string      | Y              | The name of the action (used as a key).                                                                                                                                                                                                                                                                                                                                                               |
| `[id]["actions"][j]["label"]`                                                 | string      | Y              |                                                                                                                                                                                                                                                                                                                                                                                                       |
| `[id]["actions"][j]["transitionTo"]`                                          | array       | Y              | Defines which state and status could be set with that action.                                                                                                                                                                                                                                                                                                                                         |
| `[id]["actions"][j]["transitionTo"][stateName]`                               | array       | Y              | Every stateName (state) could have connected many statuses. To add the status to array, just use the status name. (See the example, below.)                                                                                                                                                                                                                                                           |
| `[id]["actions"][j]["notes"]`                                                 | array       | N              | Notes configuration for the action.                                                                                                                                                                                                                                                                                                                                                                   |
| `[id]["actions"][j]["notes"]["required"]`                                     | boolean     | N              | disable / enable notes                                                                                                                                                                                                                                                                                                                                                                                |
| `[id]["actions"][j]["notes"]["type"]`                                         | string      | N              | An optional alternative "type" for the note, defaults to "Status update" or "Global action" if blank                                                                                                                                                                                                                                                                                                  |
| `[id]["actions"][j]["notes"]["title"]`                                        | string      | N              | An optional alternative "title" for the note, if blank the actions transition result is used (See Decorator).                                                                                                                                                                                                                                                                                         |
| `[id]["actions"][j]["users"]`                                                 | array       | N              | User ids able to use that action. Admin is always allowed for every action.                                                                                                                                                                                                                                                                                                                           |
| `[id]["actions"][j]["events"]`                                                | array       | N              | Classes which would be called by special triggers available in the workflow module.                                                                                                                                                                                                                                                                                                                   |
| `[id]["actions"][j]["events"]["before"]`                                      | array       | N              | For example: `['\\Website\\WorkflowExampleEventHandler', 'before']`. The method `before` from the `'\\Website\\WorkflowExampleEventHandler'`class will be called when the `before` event is triggered.                                                                                                                                                                                                |
| `[id]["actions"][j]["events"]["success"]`                                     | array       | N              | For example: `['\\Website\\WorkflowExampleEventHandler', 'success']`. The method `success` from the `'\\Website\\WorkflowExampleEventHandler'`class will be called when the `success` event is triggered.                                                                                                                                                                                             |
| `[id]["actions"][j]["events"]["failure"]`                                     | array       | N              | For example: `['\\Website\\WorkflowExampleEventHandler', 'failure']`. The method `failure` from the `'\\Website\\WorkflowExampleEventHandler'`class will be called when the `failure` event is triggered.                                                                                                                                                                                             |
| `[id]["actions"][j]["notificationUsers"]`                                     | array       | N              | Array with user ID's. Users who are in that range are notificated when the action is triggered.                                                                                                                                                                                                                                                                                                       |
| `[id]["actions"][j]["additionalFields"]`                                      | array       | N              | Additional fields used in the action.                                                                                                                                                                                                                                                                                                                                                                 |
| `[id]["actions"][j]["additionalFields"][k]["name"]`                           | string      | Y              | The name used in the form.                                                                                                                                                                                                                                                                                                                                                                            |
| `[id]["actions"][j]["additionalFields"][k]["fieldType"]`                      | string      | Y              | The data component name (for example: input, textarea). See the list of [available data types](../05_Objects/01_Object_Classes/01_Data_Types/README.md).                                                                                                                                                                                                                                              |
| `[id]["actions"][j]["additionalFields"][k]["title"]`                          | string      | Y              | The label used by the field.                                                                                                                                                                                                                                                                                                                                                                          |
| `[id]["actions"][j]["additionalFields"][k]["blankText"]`                      | string      | N              | The blank text used in the form component (For example it would be: *test@example.com* in the email field).                                                                                                                                                                                                                                                                                           |
| `[id]["actions"][j]["additionalFields"][k]["required"]`                       | boolean     | Y              | Whether or not the field is required.                                                                                                                                                                                                                                                                                                                                                                 |
| `[id]["actions"][j]["additionalFields"][k]["setternFn"]`                      | string,null | N              | Optional setter function (available in the element, for example in the updated object), if not specified, data will be added to notes. The Workflow manager will call the function with the whole field data. (See [the code line on Github](https://github.com/pimcore/pimcore/blob/master/pimcore/lib/Pimcore/WorkflowManagement/Workflow/Manager.php#L527-L527))                                   |
| `[id]["transitionDefinitions"]`                                               | array       | Y              | These definitions specify the true workflow, are like the sequence for actions.                                                                                                                                                                                                                                                                                                                       |
| `[id]["transitionDefinitions"][transitionName]["validActions"]`               | array       | Y              | Specify actions valid during the specific step. A `transitionName` is the unique name of the transition. For example: todo, reopened, in_progress                                                                                                                                                                                                                                                     |
| `[id]["transitionDefinitions"][transitionName]["validActions"][actionName]`   | null        | Y              | Specify valid action names (`actionName` as a key, null as a value).                                                                                                                                                                                                                                                                                                                                  |
| `[id]["transitionDefinitions"]["globalActions"]`                              | array       | N              | Actions available in every step of the workflow.                                                                                                                                                                                                                                                                                                                                                      |
| `[id]["transitionDefinitions"]["globalActions"][actionName]`                  | array       | N              | Specify valid action names (`actionName` as a key, null as a value).                                                                                                                                                                                                                                                                                                                                  |
