# Working with Assets via PHP API

Pimcore provides an object orientated PHP API to work with Assets. 

## CRUD Operations
Following lines of code show simple CRUD operations for Assets. 
 ```php
//creating and saving new asset
$newAsset = new Pimcore\Model\Asset();
$newAsset->setFilename("myAsset.png");
$newAsset->setData(file_get_contents("some-file.png"));
$newAsset->setParent(Pimcore\Model\Asset::getByPath("/"));
$newAsset->save();

//getting assets
$asset1 = Pimcore\Model\Asset::getById(3456);
$asset2 = Pimcore\Model\Asset::getByPath("/my-assets/sample.png");

//updating assets
$asset1->setData(file_get_contents("some-updated-file.png"));
$asset1->save();

//deleting assets
$asset2->delete();
 ```
  
## Asset Listings
With `Asset\Listing` lists of assets can be retrieved and filtered. The most important methods are `setCondition`, 
`setOffset`, `setLimit`, `setOrderKey`, `setOrder`. 

```php
$list = new \Pimcore\Model\Asset\Listing();
$list->setCondition("...");
$list->setOrderKey("filename");
$list->setOrder("DESC");
$list->load();
```

Please also have a look at [object listings](../05_Objects/03_Working_with_PHP_API.md#objectsListing) 
and [document listings](../03_Documents/09_Working_with_PHP_API.md#documentsListing).

[comment]: #(TODO add links)



## Custom Settings

Custom Settings/Properties can be added programmatically to every asset. This is mostly used for plugins or something 
similar.

```php 
$asset = Asset::getById(2345);
$settings = $asset->getCustomSettings();
$settings["mySetting"] = "this is my value this can be everythin also an array or an object not only a string";
$asset->setCustomSettings($settings);
$asset->save();
```


## Using (localized) Asset Metadata
Asset Metadata allow you to attach localized metadata to assets within Pimcore. These Medata can be accessed via API and 
therefore used on all output channels. 

### Examples
##### Getting Data
 ```php
$asset = Asset::getById(123);
 
 
// get the title for the current language (Zend_Locale in Zend_Registry)
$asset->getMetadata("title");
 
 
// get the English title
$asset->getMetadata("title", "en");
// if there's no title for "en" but one without a language this will be returned (fallback mechanism).
 ```
 
##### Setting Data
 ```php
 // Set the English title
 $asset->addMetadata("title", "input", "the new title", "en");
 ```


### Predefined System Metadata
There may be predefined and default fields on an Asset. That means that these fields have a special meaning and 
will be used somewhere else.

##### Image asset
There are 3 default fields, namely `title`, `alt` and `copyright`. The contents of this fields will be 
used as default `alt` and `title` attribute on any `<img>` tag generated by Pimcore for the 
corresponding image.
 
This includes for example: 
```php
// image editable on documents
<?= $this->image("myImage", ["thumbnail" => "xyz"]); ?>
 
 
// thumbnail html generator
<?= $asset->getThumbnail("xyz")->getHTML(); ?>
<?= $object->getMyImage()->getThumbnail("xyz")->getHTML(); ?>
```
The `copyright` field will be appended to every `title` and `alt` attribute separated by |. 

---

For more information about Asset Metadata also have a look at the [User Documentation]().

[comment]: #(TODO add links)
